--[[----------------------------------------------------------------------------
	Copyright 2008 João Liborio Cardoso
	All rights reserved
	
	Bongos Clock is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
	Bongos Clock is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License (<http://www.gnu.org/licenses/>) for more details.
---------------------------------------------------------------------------]]--

local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local Clock = Bongos:NewModule('Clock')

local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-Clock')
local UPDATE_DELAY = 30


--[[ Startup ]]--

function Clock:Load()
	local defaults = {
		point = "TOP",
		y = -70.7,
		x = -4.5,
	}
	
	self.bar, isNew = Bongos.Bar:Create('clock', defaults, nil, 'HIGH')
	if isNew then
		self.LoadBar(self.bar)
	end
end

function Clock:Unload()
	self.bar:Destroy()
end

function Clock:LoadBar()
	for k,v in pairs(Clock) do self[k] = v end
	
	self.nextUpdate = 0
	self.clock = Bongos:CreateSimpleIndicator(self)
	self:SetScript('OnUpdate', self.UpdateClock)
end


--[[ Clock ]]--

if not Bongos.CreateSimpleIndicator then
	function Bongos:CreateSimpleIndicator(parent) --common code for Bongos_Coords
	
		local text = parent:CreateFontString(nil, 'OVERLAY')
		text:SetFontObject('GameFontNormalSmall')
		text:SetAllPoints(parent)
		
		parent:SetHeight(24)
		parent:SetWidth(70)
		
		return text
	end
end

function Clock:UpdateClock(elapsed)
	if self.nextUpdate > 0 then
		self.nextUpdate = self.nextUpdate - elapsed
	else
		self.nextUpdate = UPDATE_DELAY
		self:UpdateClockTime(self.clock, GetGameTime())
	end
end

function Clock:UpdateClockTime(clock, hours, minutes)
	hours = hours + (self.sets.offset or 0)
	
	local pm = mod(hours, 24) >= 12
	local layout, scale
	
	if (self.sets.use24h) then
		layout, scale = TIME_TWENTYFOURHOURS, 24
	else
		scale = 12
		
		if pm then
			layout = TIME_TWELVEHOURPM
		else
			layout = TIME_TWELVEHOURAM
		end
	end
	
	hours = mod(hours, scale)
	if(hours == 0) then hours = scale end
	clock:SetText(format(layout, hours, minutes))
end


--[[ Menu ]]--

function Clock:CreateMenu()

	local menu = Bongos.Menu:Create(self.id)
	local panel = menu:AddLayoutPanel()
	
	local format = panel:CreateCheckButton(L.Use24Format)
	format:SetScript("OnShow", function(b) b:SetChecked(self.sets.use24h) end)
	format:SetScript("OnClick", function(b)
		self.sets.use24h = b:GetChecked()
		self.nextUpdate = 0
	end)
	
	local function Slider_OnShow(slider)
		slider:SetValue(self.sets.offset or 0)
	end
	
	local function Slider_UpdateValue(slider, value)
		self.sets.offset = value
		self.nextUpdate = 0
	end
	
	local slider = panel:CreateSlider(L.TimeZone, 0, 23, 1, Slider_OnShow, Slider_UpdateValue)
	
	return menu
end